
libname tz 'd:\tanzrped\sasdata';
libname cd 'd:\tanzrped\createdata';


/* **** firms investment behaviour using 207 firms with
useful capital stock and production data from wave 1 **** */

data temp1; set cd.genfirm1;
keep firm wave cap capsale caplb capcon emp vad;


data temp2; set tz.tz1new;
wave=1;
round=1;
firm=key;
proc sort; by firm;


data invest1; merge temp1 (in=a) temp2; by firm; if a;
options linesize=80;
options nolabel;

inv84=v0308c;
inv88=v0309c;
inv91=v0310c;

/* initial investment */
ipiyr=v1501y1;
ipinv=v15021;
curr=v15022;

/* most recent investment */
mriyr=v1601;
mrinv=v1602;

/* most recent acquisitions in last 5 years */
land1=v32102;
build1=v32202;
plant1=v32302;

if land1=. then land1=0;
if build1=. then build1=0;
if plant1=. then plant1=0;

yearp=v32301y;
if yearp=92 then equip92=plant1;
if yearp=92 then invlb92=land1+build1;

/* calculation of 1992 investment figure by combining
available data from 2 different sources of information */

if mriyr=1992 then invnew=mrinv;

inv92=equip92;
if inv92=. then inv92=invnew;
if inv92=. then inv92=0;

/* wave 1 adjustments */
if firm=34 then inv92=plant1;
if firm=41 then cap=17000000;
if firm=206 then cap=29200000;
if firm=206 then inv92=plant1;
if firm=408 then inv92=invlp;
if firm=501 then inv92=invlp;
if firm=523 then inv92=invlp;

inv92us=inv92/297.71;

cap92=cap;
capsal92=capsale;
caplb92=caplb;

/* ratios */

if inv92>0 then invdum=1; else invdum=0;

ivad92=inv92/vad;
icap92=inv92/cap;

if invdum=1 then do;
iivad92=inv92/vad;
iicap92=inv92/cap;
end;

/* capacity utilisation */

prodc=v1229;
prodmax=v1230;

if firm=63 then prodc=v1230;
if firm=63 then prodmax=v1229;
if firm=76 then prodc=v1230;
if firm=76 then prodmax=v1229;
if firm=78 then prodc=v1230;
if firm=78 then prodmax=v1229;

cutil=prodc/prodmax;

inv=inv92;
invlb=invlb92;

keep firm wave round vad cap92 capsal92 caplb92 inv invlb inv92 invlb92
inv84 inv88 inv91 land1 plant1 build1 yearp equip92 invnew inv92us 
invdum ivad92 icap92 iivad92 iicap92 cutil;

proc sort; by firm;

/* **** financing of wave 1 investment using data from
table on major acquisitions in last 5 years **** */

data finance1; merge temp1 (in=a) temp2; by firm; if a;

land1=v32102;
build1=v32202;
plant1=v32302;

if v32103=2 then landls=1; else landls=0;
if v32203=2 then buildls=1; else buildls=0;
if v32303=2 then plantls=1; else plantls=0;

/* sources of land financing */
landcre=v32104a2;
landps=v32104b2;
landbfr=v32104c2;
landbl=v32104d2;
landsc=v32104e2;
landbml=v32104f2;
landoth=v32104g2;
landtot=v32104t2;

if land1=. then land1=0;
if landcre=. then landcre=0;
if landps=. then landps=0;
if landbfr=. then landbfr=0;
if landbl=. then landbl=0;
if landsc=. then landsc=0;
if landbml=. then landbml=0;
if landoth=. then landoth=0;
if landtot=. then landtot=0;

landch= landcre+landps+landbfr+landbl+landsc+landbml+landoth;
check1=landtot-landch;

/* sources of building financing */
buildcre=v32204a2;
buildps=v32204b2;
buildbfr=v32204c2;
buildbl=v32204d2;
buildsc=v32204e2;
buildbml=v32204f2;
buildoth=v32204g2;
buildtot=v32204t2;

if build1=. then build1=0;
if buildcre=. then buildcre=0;
if buildps=. then buildps=0;
if buildbfr=. then buildbfr=0;
if buildbl=. then buildbl=0;
if buildsc=. then buildsc=0;
if buildbml=. then buildbml=0;
if buildoth=. then buildoth=0;
if buildtot=. then buildtot=0;

buildch= buildcre+buildps+buildbfr+buildbl+buildsc+buildbml+buildoth;
check1=buildtot-buildch;

/* sources of plant financing */
plantcre=v32304a2;
plantps=v32304b2;
plantbfr=v32304c2;
plantbl=v32304d2;
plantsc=v32304e2;
plantbml=v32304f2;
plantoth=v32304g2;
planttot=v32304t2;

if plant1=. then plant1=0;
if plantcre=. then plantcre=0;
if plantps=. then plantps=0;
if plantbfr=. then plantbfr=0;
if plantbl=. then plantbl=0;
if plantsc=. then plantsc=0;
if plantbml=. then plantbml=0;
if plantoth=. then plantoth=0;
if planttot=. then planttot=0;

plantch= plantcre+plantps+plantbfr+plantbl+plantsc+plantbml+plantoth;
check1=planttot-plantch;

keep firm wave land1 build1 plant1 landls buildls plantls
landcre landps landbfr landbl landsc landbml landoth landch
buildcre buildps buildbfr buildbl buildsc buildbml buildoth
buildch plantcre plantps plantbfr plantbl plantsc plantbml
plantoth plantch;

proc sort; by firm;

data inv1; merge invest1 finance1; by firm;
proc means; run;


/* ********* WAVE 2 STARTS HERE ************
focus on firms investment in 1993 using 182 firms with
useful data from wave 2; there is also some information
on investments in the 1990-92 period **** */


data temp3; set cd.genfirm2;
keep firm wave cap capsale caplb emp vad;
proc sort; by firm;

data temp4; set tz.tz2new;
wave=2;
round=2;
firm=v0no;
if v0no=11 then firm=1;
proc sort; by firm;

data check3; set invest1;
if mriyr=1993 then inv93a=mrinv;
if yearp=93 then inv93b=plant1;
keep firm inv93a inv93b;


data invest2; merge temp3 (in=a) temp4 check3; by firm; if a;
options nolabel;
options linesize=80;

invl90=v2601l90;
invb90=v2601b90;
inve90=v2601e90;

invl91=v2601l91;
invb91=v2601b91;
inve91=v2601e91;

invl92=v2601l92;
invb92=v2601b92;
inve92=v2601e92;

invl93=v2601l93;
invb93=v2601b93;
inve93=v2601e93;

inv93=inve93;
inv9092=inve90+inve91+inve92;
if inv93=. then inv93=0;

/* uses data on 1993 investment from wave 1*/
if inv93=0 and inv93b>0 then inv93=inv93b;

land2=invl93;
build2=invb93;
plant2=inve93;

invlb93=invl93+invb93;

if inv93=. then inv93=0;
if inv9092=. then inv9092=0;
if land2=. then land2=0;
if build2=. then build2=0;
if plant2=. then plant2=0;

inv93us=inv93/405.27;

if inv93>0 then invdum=1; else invdum=0;

cap93=cap;
capsal93=capsale;
caplb93=caplb;

/* ratios */

ivad93=inv93/vad;
icap93=inv93/cap;

if invdum=1 then do;
iivad93=inv93/vad;
iicap93=inv93/cap;
end;

inv=inv93;
invlb=invlb93;

/* capacity utilisation */

prodc=v1446a;
prodmax=v1446b;
cutil=prodc/prodmax;

keep firm wave round vad cap93 capsal93 caplb93 emp
land2 plant2 build2
inv9092 inv93 inv93us invlb93 invdum ivad93 icap93
inv invlb iivad93 iicap93 cutil ;

proc sort; by firm;

/* **** Financing of Wave 2 investment using data from
table on 1993 investments. Financial breakdown could also refer
to earlier years in table **** */

data finance2; merge temp3 (in=a) temp4; by firm; if a;

land2=v2601l93;
build2=v2601b93;
plant2=v2601e93;

if v2602l=2 then landls=1; else landls=0;
if v2602b=2 then buildls=1; else buildls=0;
if v2602e=2 then plantls=1; else plantls=0;

/* sources of land financing */
landcre=v2603la;
landps=v2603lb;
landbfr=v2603lc;
landbl=v2603ld+v2603le;
landsc=v2603lf;
landbml=v2603lg;
landoth=v2603lh+v2603li+v2603lj+v2603lk;
landtot=v2603tl;

if land2=. then land2=0;
if landcre=. then landcre=0;
if landps=. then landps=0;
if landbfr=. then landbfr=0;
if landbl=. then landbl=0;
if landsc=. then landsc=0;
if landbml=. then landbml=0;
if landoth=. then landoth=0;
if landtot=. then landtot=0;

landch= landcre+landps+landbfr+landbl+landsc+landbml+landoth;
check2l=landtot-landch;

/* sources of building financing */
buildcre=v2603ba;
buildps=v2603bb;
buildbfr=v2603bc;
buildbl=v2603bd+v2603be;
buildsc=v2603bf;
buildbml=v2603bg;
buildoth=v2603bh+v2603bi+v2603bj+v2603bk;
buildtot=v2603tb;

if build2=. then build2=0;
if buildcre=. then buildcre=0;
if buildps=. then buildps=0;
if buildbfr=. then buildbfr=0;
if buildbl=. then buildbl=0;
if buildsc=. then buildsc=0;
if buildbml=. then buildbml=0;
if buildoth=. then buildoth=0;
if buildtot=. then buildtot=0;

buildch= buildcre+buildps+buildbfr+buildbl+buildsc+buildbml+buildoth;
check2b=buildtot-buildch;

/* sources of plant financing */
plantcre=v2603ea;
plantps=v2603eb;
plantbfr=v2603ec;
plantbl=v2603ed+v2603ee;
plantsc=v2603ef;
plantbml=v2603eg;
plantoth=v2603eh+v2603ei+v2603ej+v2603ek;
planttot=v2603te;

if plant2=. then plant2=0;
if plantcre=. then plantcre=0;
if plantps=. then plantps=0;
if plantbfr=. then plantbfr=0;
if plantbl=. then plantbl=0;
if plantsc=. then plantsc=0;
if plantbml=. then plantbml=0;
if plantoth=. then plantoth=0;
if planttot=. then planttot=0;

plantch= plantcre+plantps+plantbfr+plantbl+plantsc+plantbml+plantoth;
check2e=planttot-plantch;

keep firm wave land2 build2 plant2 landls buildls plantls
landcre landps landbfr landbl landsc landbml landoth landch
buildcre buildps buildbfr buildbl buildsc buildbml buildoth
buildch plantcre plantps plantbfr plantbl plantsc plantbml
plantoth plantch;

proc sort; by firm;


data inv2; merge invest2 finance2; by firm;
proc means; run;



/* ********* WAVE 3 STARTS HERE ************
focus on firms investment in 1994/95 using 130 firms with
useful data from wave 3; there is also some information
on investments in the 1992/93 and 1993/94 periods **** */


data temp5; set cd.genfirm3;
keep firm wave cap capsale caplb emp vad;
proc sort; by firm;

data temp6; set tz.tz3new;
wave=3;
round=3;
firm=key;
proc sort; by firm;


data invest3; merge temp5 (in=a) temp6; by firm; if a;
options nolabel;
options linesize=80;

/* no question asked about year business
started in wave 3 */

invl93=v3201l93;
invb93=v3201b93;
inve93=v3201e93;

invl94=v3201l94;
invb94=v3201b94;
inve94=v3201e94;

invl95=v3201l95;
invb95=v3201b95;
inve95=v3201e95;

inv94=inve94;
inv95=inve95;

if inv94=. then inv94=0;
if inv95=. then inv95=0;
if invl94=. then invl94=0;
if invl95=. then invl95=0;
if invb94=. then invb94=0;
if invb95=. then invb95=0;

land3=invl95;
build3=invb95;
plant3=inve95;

inv95=inv94+inv95;
invlb95=invl94+invl95+invb94+invb95;

inv=inv95;
invlb=invlb95;

inv94us=inv94/509.63;
inv95us=inv95/574.76;

if inv95>0 then invdum=1; else invdum=0;

cap95=cap;
capsal95=capsale;
caplb95=caplb;

/* ratios */

ivad95=inv95/vad;
icap95=inv95/cap;

if invdum=1 then do;
iivad95=inv95/vad;
iicap95=inv95/cap;
end;

/* capacity utilisation */

prodc=v1659a;
prodmax=v1659b;
cutil=prodc/prodmax;

keep firm wave round vad cap95 capsal95 caplb95 emp
invl93 invb93 inve93 land3 plant3 build3
inv94 inv95 invlb95 inv94us inv95us invdum ivad95 icap95
iivad95 iicap95 cutil inv invlb;

proc sort; by firm;


/* **** Financing of Wave 3 investment using data from
table on 1994/95 investments. Financial breakdown could also refer
to earlier years in table **** */

data finance3; merge temp5 (in=a) temp6; by firm; if a;

land3=v3201l95;
build3=v3201b95;
plant3=v3201e95;

if v3202l=2 then landls=1; else landls=0;
if v3202b=2 then buildls=1; else buildls=0;
if v3202e=2 then plantls=1; else plantls=0;

/* sources of land financing */
landcre=v3203la;
landps=v3203lb;
landbfr=v3203lc;
landbl=v3203ld+v3203le;
landsc=v3203lf;
landbml=v3203lg;
landoth=v3203lh+v3203li+v3203lj+v3203lk;

if land3=. then land3=0;
if landcre=. then landcre=0;
if landps=. then landps=0;
if landbfr=. then landbfr=0;
if landbl=. then landbl=0;
if landsc=. then landsc=0;
if landbml=. then landbml=0;
if landoth=. then landoth=0;
if landtot=. then landtot=0;

landch= landcre+landps+landbfr+landbl+landsc+landbml+landoth;


/* sources of building financing */
buildcre=v3203ba;
buildps=v3203bb;
buildbfr=v3203bc;
buildbl=v3203bd+v3203be;
buildsc=v3203bf;
buildbml=v3203bg;
buildoth=v3203bh+v3203bi+v3203bj+v3203bk;

if build3=. then build3=0;
if buildcre=. then buildcre=0;
if buildps=. then buildps=0;
if buildbfr=. then buildbfr=0;
if buildbl=. then buildbl=0;
if buildsc=. then buildsc=0;
if buildbml=. then buildbml=0;
if buildoth=. then buildoth=0;
if buildtot=. then buildtot=0;

buildch= buildcre+buildps+buildbfr+buildbl+buildsc+buildbml+buildoth;


/* sources of plant financing */
plantcre=v3203ea;
plantps=v3203eb;
plantbfr=v3203ec;
plantbl=v3203ed+v3203ee;
plantsc=v3203ef;
plantbml=v3203eg;
plantoth=v3203eh+v3203ei+v3203ej+v3203ek;
planttot=v3203te;

if plant3=. then plant3=0;
if plantcre=. then plantcre=0;
if plantps=. then plantps=0;
if plantbfr=. then plantbfr=0;
if plantbl=. then plantbl=0;
if plantsc=. then plantsc=0;
if plantbml=. then plantbml=0;
if plantoth=. then plantoth=0;
if planttot=. then planttot=0;

plantch= plantcre+plantps+plantbfr+plantbl+plantsc+plantbml+plantoth;

keep firm wave land3 build3 plant3 landls buildls plantls
landcre landps landbfr landbl landsc landbml landoth landch
buildcre buildps buildbfr buildbl buildsc buildbml buildoth
buildch plantcre plantps plantbfr plantbl plantsc plantbml
plantoth plantch;

proc sort; by firm;


data inv3; merge invest3 finance3; by firm;
proc means; run;



/* merged investment dataset */

data tempa; set inv1;
invdum1=invdum;
proc sort; by firm round;

data tempb; set inv2;
invdum2=invdum;
proc sort; by firm round;

data tempc; set inv3;
invdum3=invdum;
proc sort; by firm round;


data cd.invest; merge tempa tempb tempc; by firm round;
proc means; run;

/*
keep firm wave round cap92 cap93 cap95 capsal92 capsal93
capsal95 caplb92 caplb93 caplb95 vad inv84 inv88 inv91
land1 build1 plant1 land2 build2 plant2 land3 build3 plant3
inv92 inv93 inv94 inv95 inv invlb invlb92 invlb93 invlb95
invdum1 invdum2 invdum3 invdum;
*/



/* purpose of investment in equipment */

data type3; merge temp5 (in=a) temp6; by firm; if a;

curr3=v3304c;
/* curr03=v3304c#; */
amount3=v3304a;

new3=v3305;
source3=v3306;
type3=v3307;

cost3=v3308;
qual3=v3309;

soldlbe3=v3310;
sale3=v3311;
price3=v3312;
whysold3=v3313;
/* whyspec3=v3313#; */

proc means; run;


